﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="LabResultsChangeHistory.ascx.cs" Inherits="controls_LabResultsChangeHistory" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Panel runat="server" ID="PanelChangeHistoryControl" BorderStyle="0">
<asp:Panel runat="server" ID="PanelLabResultsChangeHistory" GroupingText="Change History">
    <asp:GridView ID="GridViewLabResultsChangeHistory" runat="server" 
        DataSourceID="ObjectDataSourceLabResultsChangeHistory"
        AllowPaging="True" SkinID = "Unsortable"
        AutoGenerateColumns="False"  
        DataKeyNames="LABRESULT_CHANGE_Tracking_ID" 
        PageSize="5"
        Width="100%">
        <Columns>
            <asp:TemplateField HeaderText="Date">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelChangeDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CHANGE_DATE","{0:d}")), false) + " " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CHANGE_DATE","{0:t}")), false) %>' Width = "100%"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Field" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelChangeField" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CHANGE_FIELD")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Change">
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLinkChangeDescription" runat="server" 
                    NavigateUrl='<%# AntiXssEncoder.UrlEncode(Convert.ToString( Eval("NAVIGATION_URL"))) %>'           
                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CHANGE_DESCRIPTION")), false) %>' 
                    Visible='<%# Eval("HeperLinkVisible") %>'>
                    </asp:HyperLink>

                    <asp:Label SkinID="DataLabel" ID="LabelChangeDescription" runat="server" 
                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CHANGE_DESCRIPTION")),false) %>'
                    Visible='<%# Eval("LabelVisible") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
</asp:Panel>
<br />
</asp:Panel>
<asp:ObjectDataSource ID="ObjectDataSourceLabResultsChangeHistory" runat="server" 
    SelectMethod="SelectByWorkflow" 
    SelectCountMethod="SelectAllCount"
    TypeName="VeteransAffairs.Registries.BusinessManager.LabResultsTrackingManager"
    StartRowIndexParameterName="startRow" 
    MaximumRowsParameterName="maxRows" 
    SortParameterName="sort"
    EnablePaging="True" >
    <SelectParameters>
        <asp:ControlParameter ConvertEmptyStringToNull="true"
            DefaultValue="" Direction="Input" Name="id" ControlID="HiddenFieldWorkFlowCaseId" Type="Int32" />
        <asp:Parameter Name="sort" Type="String" DefaultValue="LABRESULT_CHANGE_TRACKING_ID" />
        <asp:Parameter Name="startRow" Type="Int32" />
        <asp:Parameter Name="maxRows" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:HiddenField runat="server" ID="HiddenFieldWorkFlowCaseId" />